/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.sk89q.worldedit.bukkit.adapter.impl.Spigot_Cardboard;
import com.sk89q.worldedit.world.DataFixer;
import java.util.stream.Collectors;
import net.minecraft.class_1208;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class DataConverters_Cardboard_1_17
extends DataFixerBuilder
implements DataFixer {
    private final Spigot_Cardboard adapter;
    private static final class_2509 OPS_NBT = class_2509.field_11560;
    private static final int LEGACY_VERSION = 1343;
    private static int DATA_VERSION;
    static DataConverters_Cardboard_1_17 INSTANCE;
    private com.mojang.datafixers.DataFixer fixer;

    DataConverters_Cardboard_1_17(int dataVersion, Spigot_Cardboard adapter) {
        super(dataVersion);
        DATA_VERSION = dataVersion;
        INSTANCE = this;
        this.adapter = adapter;
    }

    public <T> T fixUp(DataFixer.FixType<T> type, T original, int srcVer) {
        if (type == DataFixer.FixTypes.BLOCK_STATE) {
            return (T)this.fixBlockState((String)original, srcVer);
        }
        if (type == DataFixer.FixTypes.ITEM_TYPE) {
            return (T)this.fixItemType((String)original, srcVer);
        }
        return original;
    }

    private String fixItemType(String key, int srcVer) {
        return DataConverters_Cardboard_1_17.fixName(key, srcVer, class_1208.field_5713);
    }

    private static String fixName(String key, int srcVer, DSL.TypeReference type) {
        return ((class_2520)DataConverters_Cardboard_1_17.INSTANCE.fixer.update(type, new Dynamic((DynamicOps)OPS_NBT, (Object)class_2519.method_23256((String)key)), srcVer, DATA_VERSION).getValue()).method_10714();
    }

    private String fixBlockState(String blockState, int srcVer) {
        class_2487 stateNBT = DataConverters_Cardboard_1_17.stateToNBT(blockState);
        Dynamic dynamic = new Dynamic((DynamicOps)OPS_NBT, (Object)stateNBT);
        class_2487 fixed = (class_2487)DataConverters_Cardboard_1_17.INSTANCE.fixer.update(class_1208.field_5720, dynamic, srcVer, DATA_VERSION).getValue();
        return this.nbtToState(fixed);
    }

    private String nbtToState(class_2487 tagCompound) {
        StringBuilder sb = new StringBuilder();
        sb.append(tagCompound.method_10558("Name"));
        if (tagCompound.method_10573("Properties", 10)) {
            sb.append('[');
            class_2487 props = tagCompound.method_10562("Properties");
            sb.append(props.method_10541().stream().map(k -> String.valueOf(k) + "=" + props.method_10558(k).replace("\"", "")).collect(Collectors.joining(",")));
            sb.append(']');
        }
        return sb.toString();
    }

    private static class_2487 stateToNBT(String blockState) {
        int propIdx = blockState.indexOf(91);
        class_2487 tag = new class_2487();
        if (propIdx < 0) {
            tag.method_10582("Name", blockState);
        } else {
            String[] propArr;
            tag.method_10582("Name", blockState.substring(0, propIdx));
            class_2487 propTag = new class_2487();
            String props = blockState.substring(propIdx + 1, blockState.length() - 1);
            String[] stringArray = propArr = props.split(",");
            int n = propArr.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] split = pair.split("=");
                propTag.method_10582(split[0], split[1]);
                ++n2;
            }
            tag.method_10566("Properties", (class_2520)propTag);
        }
        return tag;
    }
}

